#version 330
#extension GL_EXT_gpu_shader4 : enable
//Heart_fireworksMod01.fsh  by   bhuwan0000
//https://www.shadertoy.com/view/3d2cWc
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

//fireworks in heart shape
//np = no. of particles
//snp = no. of spawned particles

#define rad(x) radians(x)
#define np 20.
#define snp 40.
#define spawn 1
#define trail 1

//random value
vec2 N22(vec2 p){
    vec3 a = fract(p.xyx*vec3(123.34, 234.34, 345.65));
    a += dot(a, a+34.45);
	return fract(vec2(a.x*a.y, a.y*a.z));
}

//particle
vec3 particle(vec2 st, vec2 p, float r, vec3 col){
 	float d = length(st-p);
    d = smoothstep(r, r-2.0/iResolution.y, d);//d<r?1.0:0.0;
    return d*col;
}
//particle with light
vec3 burst(vec2 st, vec2 pos, float r, vec3 col, int heart) {
	st -= pos;
    if (heart==1) st.y -= sqrt(abs(st.x))*0.1;
    r *=0.6*r;
    return (r/dot(st, st))*col*0.6;
}

//displacement with s = p0 + ut + 0.5at^2
vec2 get_pos(vec2 u, vec2 a, vec2 p0, float t, float ang){
    ang = rad(ang);
    vec2 d = p0 + vec2(u.x*cos(ang), u.y*sin(ang))*t + 0.5*a*t*t;
    return d;
}
//velocity at time t
vec2 get_velocity(vec2 u, vec2 a, float t, float ang){
    ang = rad(ang);
    return vec2(u.x*cos(ang), u.y*sin(ang)) + a*t;
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    // Normalized pixel coordinates (from -1 to 1)
    vec2 uv = (2.*(gl_FragCoord.xy) -iResolution.xy)/iResolution.y;
    float aspect = iResolution.x/iResolution.y;
    vec3 col = vec3(0.0);
    float t = mod(iTime, 5.0);
    
    //particle
    float r = 0.04;
    vec2 u = vec2(5.); //init velocity
    vec2 a = vec2(0.0, -9.8); //acc due to gravity
    float ang = 75.0; //angle of projection

    vec3 p1 = vec3(0.0); //particle
    
    for (float i=0.; i<np; i++)
    {
        vec2 rand = N22(vec2(i));
        vec2 ip = vec2(sin(15.*rand.x)*aspect, -1.+r); //initial pos
        u = vec2(sin(5.*rand.x), 5.+sin(4.*rand.y)); //initial velocity
        float t1 = t-i/5.;
    	vec2 s = get_pos(u, a, ip, t1, ang); // displacement
    	vec2 v = get_velocity(u, a, t1, ang);
        float Tf = 2.0*u.y*sin(rad(ang))/abs(a.y); //time of flight
		vec2 H = get_pos(u, a, ip, Tf/2.0, ang); //max height
        
        vec3 pcol = vec3(sin(22.*rand.x), sin(5.*rand.y), sin(1.*rand.x)); //color per particle

        if (v.y<-0.5){
            //p1+= burst(uv, H, max(0.0, 0.1-(t1*t1-Tf*0.5)), pcol*0.5, 1 );
        	r=0.0; //die
        }
        p1 += burst(uv, s, r, pcol, 0); //main particle
        
        //trail particle
        if (trail==1){
        	for (float k=4.0; k>0.0; k--){
                vec2 strail = get_pos(u, a, ip, t1-(k*0.02), ang); //delay for trail particles
        		p1 += burst(uv, strail, v.y<-0.5?0.0:r-(k*0.006), pcol, 0);
        	}
        }
        
        //spawn
        if (v.y<=0.0 && t1>=Tf/2.0 && spawn==1)
        {
            for (float j=0.0; j<snp; j++)
            {
                vec2 rand2 = N22(vec2(j));
                float ang2 = (j*(360./snp));
                r = 0.035; // radius of spawned particles
                r -= (t1-Tf*0.5)*0.04;
                //r/=(t-(Tf/2.)+0.2);
                
                float x = cos(rad(ang2)); //coords of unit circle 
                float y = sin(rad(ang2));
                
                y = y + abs(x) * sqrt( (8.- abs(x))/50.0 ); // heart shape as a function of j
				
                vec2 heart = vec2(x*x + y*y)*(0.4/(t1*sqrt(t1))); //velocity vector
                vec2 S = get_pos(heart, a*0.03, H, t1-(Tf/2.), ang2);
                pcol = vec3(sin(8.*rand2.x), sin(6.*rand2.y), sin(2.*rand2.x)); // color per spawn particle
                p1 += burst(uv, S, max(0.0,r), pcol, 0);
                
            }
        } 

    }
    
    //bg
    col = p1;
    vec3 night = vec3(0.06, 0.02, 0.18)*vec3(uv.y*0.5+0.5);
    col += night*(1.0-p1);
    //col = vec3(light(uv, vec2(0.0), 0.1));
    gl_FragColor = vec4(col,1.0);
}